"use strict";
exports.__esModule = true;
exports.isArrayOfSize = void 0;
var is_array_1 = require("./is-array");
var is_number_1 = require("./is-number");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is an `Array` containing a specific number of values.
 * @param size 4
 * @param value ['i', 'contain', 4, 'items']
 * @matcherName toBeArrayOfSize
 * @memberMatcherName toHaveArrayOfSize
 * @matcherMessage expected ${value} to be an array containing exactly ${size}
 * items
 * @matcherNotMessage expected ${value} not to be an array containing exactly
 * ${size} items
 */
exports.isArrayOfSize = (0, curry2_1.curry2)(function (size, value) {
    return (0, is_array_1.isArray)(value) && (0, is_number_1.isNumber)(size) && value.length === size;
});
