"use strict";
exports.__esModule = true;
exports.isArrayIncludingOnly = void 0;
var is_array_1 = require("./is-array");
var curry2_1 = require("./lib/curry2");
var every_1 = require("./lib/every");
var is_jest_equal_1 = require("./lib/is-jest-equal");
var some_1 = require("./lib/some");
/**
 * Asserts that a value is an `Array` including only the values provided in the
 * given `allowedValues` array and no others. The order and number of times each
 * value appears in either array does not matter. Returns true unless `value`
 * contains a value which does not feature in `allowedValues`.
 * @param allowedValues [1, 5, 10]
 * @param value [5, 10, 1]
 * @matcherName toBeArrayIncludingOnly
 * @memberMatcherName toHaveArrayIncludingOnly
 * @matcherMessage expected ${value} to only include values featured in
 * ${allowedValues} and no others
 * @matcherNotMessage expected ${value} not to only include values featured in
 * ${allowedValues} and no others
 */
exports.isArrayIncludingOnly = (0, curry2_1.curry2)(function (allowedValues, value) {
    return (0, is_array_1.isArray)(allowedValues) &&
        (0, is_array_1.isArray)(value) &&
        (0, every_1.every)(function (member) { return (0, some_1.some)((0, is_jest_equal_1.isJestEqual)(member), allowedValues); }, value);
});
