"use strict";
exports.__esModule = true;
exports.isArrayIncludingAllOf = void 0;
var is_array_1 = require("./is-array");
var curry2_1 = require("./lib/curry2");
var every_1 = require("./lib/every");
var is_jest_equal_1 = require("./lib/is-jest-equal");
var some_1 = require("./lib/some");
/**
 * Asserts that `value` is an `Array` including all of the values provided in
 * `requiredValues`. It could also include additional values or be in a
 * different order, but if every value in `requiredValues` features in `value`
 * then this will return `true`.
 * @param requiredValues ['Ivo', 14]
 * @param value [12, 0, 14, 'Ivo']
 * @matcherName toBeArrayIncludingAllOf
 * @memberMatcherName toHaveArrayIncludingAllOf
 * @matcherMessage expected ${value} to include every value provided in
 * ${requiredValues}
 * @matcherNotMessage expected ${value} not to include every value provided in
 * ${requiredValues}
 */
exports.isArrayIncludingAllOf = (0, curry2_1.curry2)(function (requiredValues, value) {
    return (0, is_array_1.isArray)(requiredValues) &&
        (0, is_array_1.isArray)(value) &&
        (0, every_1.every)(function (requiredValue) { return (0, some_1.some)((0, is_jest_equal_1.isJestEqual)(requiredValue), value); }, requiredValues);
});
