"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toStartWithMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toStartWithMatcher = function (value, otherString) {
    return (0, create_result_1.createResult)({
        message: function () { return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to start with ").concat((0, jest_matcher_utils_1.printExpected)(otherString)); },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to start with ").concat((0, jest_matcher_utils_1.printExpected)(otherString));
        },
        pass: (0, expect_more_1.startsWith)(otherString, value)
    });
};
exports.toStartWithMatcher = toStartWithMatcher;
expect.extend({ toStartWith: exports.toStartWithMatcher });
