/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that value is a string whose trailing characters are equal to those of the provided string.
             * @example
             * expect('JavaScript').toEndWith('Script');
             */
            toEndWith(otherString: unknown): R;
        }
        interface Expect {
            /**
             * Asserts that value is a string whose trailing characters are equal to those of the provided string.
             * @example
             * expect('JavaScript').toEqual(
             *   expect.toEndWith('Script')
             * );
             */
            toEndWith<T>(otherString: unknown): JestMatchers<T>;
        }
    }
}
export declare const toEndWithMatcher: (value: unknown, otherString: unknown) => jest.CustomMatcherResult;
