"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeWithinRangeMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeWithinRangeMatcher = function (value, floor, ceiling) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be greater than or equal to ").concat((0, jest_matcher_utils_1.printExpected)(floor), " and less than or equal to ").concat((0, jest_matcher_utils_1.printExpected)(ceiling));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be greater than or equal to ").concat((0, jest_matcher_utils_1.printExpected)(floor), " and less than or equal to ").concat((0, jest_matcher_utils_1.printExpected)(ceiling));
        },
        pass: (0, expect_more_1.isWithinRange)(floor, ceiling, value)
    });
};
exports.toBeWithinRangeMatcher = toBeWithinRangeMatcher;
expect.extend({ toBeWithinRange: exports.toBeWithinRangeMatcher });
