/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is safe to attempt to read property values from.
             * @example
             * expect({}).toBeWalkable();
             */
            toBeWalkable(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is safe to attempt to read property values from.
             * @example
             * expect({}).toEqual(
             *   expect.toBeWalkable()
             * );
             */
            toBeWalkable<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeWalkableMatcher: (value: unknown) => jest.CustomMatcherResult;
