/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid `String` containing at least one character which is not whitespace.
             * @example
             * expect('i am visible').toBeVisibleString();
             */
            toBeVisibleString(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid `String` containing at least one character which is not whitespace.
             * @example
             * expect('i am visible').toEqual(
             *   expect.toBeVisibleString()
             * );
             */
            toBeVisibleString<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeVisibleStringMatcher: (value: unknown) => jest.CustomMatcherResult;
