/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an instance of `Date` whose internal value is valid. `Date` is little like `Promise` in that it is a container for a value. For example, `new Date('wut?')` is a valid `Date` which wraps a value that is not valid.
             * @example
             * expect(new Date('2020-01-01')).toBeValidDate();
             */
            toBeValidDate(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an instance of `Date` whose internal value is valid. `Date` is little like `Promise` in that it is a container for a value. For example, `new Date('wut?')` is a valid `Date` which wraps a value that is not valid.
             * @example
             * expect(new Date('2020-01-01')).toEqual(
             *   expect.toBeValidDate()
             * );
             */
            toBeValidDate<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeValidDateMatcher: (value: unknown) => jest.CustomMatcherResult;
