/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is `true` or `new Boolean(true)`.
             * @example
             * expect(true).toBeTrue();
             */
            toBeTrue(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is `true` or `new Boolean(true)`.
             * @example
             * expect(true).toEqual(
             *   expect.toBeTrue()
             * );
             */
            toBeTrue<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeTrueMatcher: (value: unknown) => jest.CustomMatcherResult;
