/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `RegExp`.
             * @example
             * expect(new RegExp('i am a regular expression')).toBeRegExp();
             */
            toBeRegExp(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `RegExp`.
             * @example
             * expect(new RegExp('i am a regular expression')).toEqual(
             *   expect.toBeRegExp()
             * );
             */
            toBeRegExp<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeRegExpMatcher: (value: unknown) => jest.CustomMatcherResult;
