/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an odd `Number`.
             * @example
             * expect(5).toBeOddNumber();
             */
            toBeOddNumber(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an odd `Number`.
             * @example
             * expect(5).toEqual(
             *   expect.toBeOddNumber()
             * );
             */
            toBeOddNumber<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeOddNumberMatcher: (value: unknown) => jest.CustomMatcherResult;
