/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid `Number` or `new Number()` and not `NaN`.
             * @example
             * expect(8).toBeNumber();
             */
            toBeNumber(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid `Number` or `new Number()` and not `NaN`.
             * @example
             * expect(8).toEqual(
             *   expect.toBeNumber()
             * );
             */
            toBeNumber<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeNumberMatcher: (value: unknown) => jest.CustomMatcherResult;
