/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is equal to ${other} or null.
             * @example
             * expect({ x: 12, y: 22 }).toBeNullableOf({
             *   x: expect.toBeNumber(),
             *   y: expect.toBeNumber(),
             * });
             * expect(null).toBeNullableOf({
             *   x: expect.toBeNumber(),
             *   y: expect.toBeNumber(),
             * });
             */
            toBeNullableOf(other: unknown): R;
        }
        interface Expect {
            /**
             * Asserts that a value is equal to ${other} or null.
             * @example
             * expect({ x: 12, y: 22 }).toEqual(
             *   expect.toBeNullableOf({
             *     x: expect.toBeNumber(),
             *     y: expect.toBeNumber()
             *     })
             * );
             * expect(null).toEqual(
             *   expect.toBeNullableOf({
             *     x: expect.toBeNumber(),
             *     y: expect.toBeNumber()
             *     })
             * );
             */
            toBeNullableOf<T>(other: unknown): JestMatchers<T>;
        }
    }
}
export declare const toBeNullableOfMatcher: (value: unknown, other: unknown) => jest.CustomMatcherResult;
