/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Object` containing at least one own member.
             * @example
             * expect({ i: 'am not empty' }).toBeNonEmptyObject();
             */
            toBeNonEmptyObject(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Object` containing at least one own member.
             * @example
             * expect({ i: 'am not empty' }).toEqual(
             *   expect.toBeNonEmptyObject()
             * );
             */
            toBeNonEmptyObject<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeNonEmptyObjectMatcher: (value: unknown) => jest.CustomMatcherResult;
