"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeJsonStringMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeJsonStringMatcher = function (value) {
    return (0, create_result_1.createResult)({
        message: function () { return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be a string of valid JSON"); },
        notMessage: function () { return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be a string of valid JSON"); },
        pass: (0, expect_more_1.isJsonString)(value)
    });
};
exports.toBeJsonStringMatcher = toBeJsonStringMatcher;
expect.extend({ toBeJsonString: exports.toBeJsonStringMatcher });
