"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeIso8601Matcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeIso8601Matcher = function (value) {
    return (0, create_result_1.createResult)({
        message: function () { return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be a valid ISO 8601 date string"); },
        notMessage: function () { return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be a valid ISO 8601 date string"); },
        pass: (0, expect_more_1.isIso8601)(value)
    });
};
exports.toBeIso8601Matcher = toBeIso8601Matcher;
expect.extend({ toBeIso8601: exports.toBeIso8601Matcher });
