/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `Function`.
             * @example
             * expect(() => 'i am a function').toBeFunction();
             */
            toBeFunction(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `Function`.
             * @example
             * expect(() => 'i am a function').toEqual(
             *   expect.toBeFunction()
             * );
             */
            toBeFunction<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeFunctionMatcher: (value: unknown) => jest.CustomMatcherResult;
