/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is `false` or `new Boolean(false)`.
             * @example
             * expect(false).toBeFalse();
             */
            toBeFalse(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is `false` or `new Boolean(false)`.
             * @example
             * expect(false).toEqual(
             *   expect.toBeFalse()
             * );
             */
            toBeFalse<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeFalseMatcher: (value: unknown) => jest.CustomMatcherResult;
