/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an even `Number`.
             * @example
             * expect(2).toBeEvenNumber();
             */
            toBeEvenNumber(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an even `Number`.
             * @example
             * expect(2).toEqual(
             *   expect.toBeEvenNumber()
             * );
             */
            toBeEvenNumber<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeEvenNumberMatcher: (value: unknown) => jest.CustomMatcherResult;
