/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid `String` containing no characters.
             * @example
             * expect('').toBeEmptyString();
             */
            toBeEmptyString(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid `String` containing no characters.
             * @example
             * expect('').toEqual(
             *   expect.toBeEmptyString()
             * );
             */
            toBeEmptyString<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeEmptyStringMatcher: (value: unknown) => jest.CustomMatcherResult;
