/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `Number` which results in a whole number when divided by another.
             * @example
             * expect(12).toBeDivisibleBy(2);
             */
            toBeDivisibleBy(other: number): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `Number` which results in a whole number when divided by another.
             * @example
             * expect(12).toEqual(
             *   expect.toBeDivisibleBy(2)
             * );
             */
            toBeDivisibleBy<T>(other: number): JestMatchers<T>;
        }
    }
}
export declare const toBeDivisibleByMatcher: (value: unknown, other: number) => jest.CustomMatcherResult;
