"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeDecimalNumberMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeDecimalNumberMatcher = function (value) {
    return (0, create_result_1.createResult)({
        message: function () { return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be a number with positive decimal places"); },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be a number with positive decimal places");
        },
        pass: (0, expect_more_1.isDecimalNumber)(value)
    });
};
exports.toBeDecimalNumberMatcher = toBeDecimalNumberMatcher;
expect.extend({ toBeDecimalNumber: exports.toBeDecimalNumberMatcher });
