/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a `Number` with positive decimal places.
             * @example
             * expect(12.55).toBeDecimalNumber();
             */
            toBeDecimalNumber(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a `Number` with positive decimal places.
             * @example
             * expect(12.55).toEqual(
             *   expect.toBeDecimalNumber()
             * );
             */
            toBeDecimalNumber<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeDecimalNumberMatcher: (value: unknown) => jest.CustomMatcherResult;
