/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an instance of `Date`.
             * @example
             * expect(new Date('2019-12-31')).toBeDate();
             */
            toBeDate(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an instance of `Date`.
             * @example
             * expect(new Date('2019-12-31')).toEqual(
             *   expect.toBeDate()
             * );
             */
            toBeDate<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeDateMatcher: (value: unknown) => jest.CustomMatcherResult;
