/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an instance of `Date` occurring on or after the exact date and time of another.
             * @example
             * expect(new Date('2019-12-31')).toBeDateOnOrAfter(new Date('2019-12-15'));
             */
            toBeDateOnOrAfter(other: unknown): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an instance of `Date` occurring on or after the exact date and time of another.
             * @example
             * expect(new Date('2019-12-31')).toEqual(
             *   expect.toBeDateOnOrAfter(new Date('2019-12-15'))
             * );
             */
            toBeDateOnOrAfter<T>(other: unknown): JestMatchers<T>;
        }
    }
}
export declare const toBeDateOnOrAfterMatcher: (value: unknown, other: unknown) => jest.CustomMatcherResult;
