"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeDateBetweenMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeDateBetweenMatcher = function (value, floor, ceiling) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be an instance of Date occurring on or after ").concat((0, jest_matcher_utils_1.printExpected)(floor), " and on or before ").concat((0, jest_matcher_utils_1.printExpected)(ceiling));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be an instance of Date occurring on or after ").concat((0, jest_matcher_utils_1.printExpected)(floor), " and on or before ").concat((0, jest_matcher_utils_1.printExpected)(ceiling));
        },
        pass: (0, expect_more_1.isDateBetween)(floor, ceiling, value)
    });
};
exports.toBeDateBetweenMatcher = toBeDateBetweenMatcher;
expect.extend({ toBeDateBetween: exports.toBeDateBetweenMatcher });
