/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is `true`, `false`, `new Boolean(true)`, or `new Boolean(false)`.
             * @example
             * expect(false).toBeBoolean();
             */
            toBeBoolean(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is `true`, `false`, `new Boolean(true)`, or `new Boolean(false)`.
             * @example
             * expect(false).toEqual(
             *   expect.toBeBoolean()
             * );
             */
            toBeBoolean<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeBooleanMatcher: (value: unknown) => jest.CustomMatcherResult;
