/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid instance of `Date` whose value occurs before that of another.
             * @example
             * expect(new Date('2019-12-31')).toBeBefore(new Date('2020-01-01'));
             */
            toBeBefore(other: Date): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid instance of `Date` whose value occurs before that of another.
             * @example
             * expect(new Date('2019-12-31')).toEqual(
             *   expect.toBeBefore(new Date('2020-01-01'))
             * );
             */
            toBeBefore<T>(other: Date): JestMatchers<T>;
        }
    }
}
export declare const toBeBeforeMatcher: (value: unknown, other: Date) => jest.CustomMatcherResult;
