/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid `Array` containing none or any number of items of any type.
             * @example
             * expect([2, true, 'string']).toBeArray();
             */
            toBeArray(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid `Array` containing none or any number of items of any type.
             * @example
             * expect([2, true, 'string']).toEqual(
             *   expect.toBeArray()
             * );
             */
            toBeArray<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayMatcher: (value: unknown) => jest.CustomMatcherResult;
