"use strict";
exports.__esModule = true;
exports.toBeArrayOfMatcher = void 0;
var expect_utils_1 = require("@jest/expect-utils");
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeArrayOfMatcher = function (value, other) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be an array, containing only values equal to ").concat((0, jest_matcher_utils_1.printExpected)(other));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be a non-empty array, containing only values equal to ").concat((0, jest_matcher_utils_1.printExpected)(other));
        },
        pass: (0, expect_more_1.isArray)(value) && value.every(function (member) { return (0, expect_utils_1.equals)(member, other); })
    });
};
exports.toBeArrayOfMatcher = toBeArrayOfMatcher;
expect.extend({ toBeArrayOf: exports.toBeArrayOfMatcher });
