/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Array` where every member is equal to ${other}.
             * @example
             * expect([{ name: 'Guybrush' }, { name: 'Elaine' }]).toBeArrayOf({
             *   name: expect.toBeNonEmptyString()
             * });
             */
            toBeArrayOf(other: unknown): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Array` containing only `Boolean` values.
             * @example
             * expect([{ name: 'Guybrush' }, { name: 'Elaine' }]).toEqual(
             *   expect.toBeArrayOf({ name: expect.toBeNonEmptyString() })
             * );
             */
            toBeArrayOf<T>(other: unknown): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayOfMatcher: (value: unknown, other: unknown) => jest.CustomMatcherResult;
