/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Array` containing only `Object` values.
             * @example
             * expect([{}, new Object()]).toBeArrayOfObjects();
             */
            toBeArrayOfObjects(): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Array` containing only `Object` values.
             * @example
             * expect([{}, new Object()]).toEqual(
             *   expect.toBeArrayOfObjects()
             * );
             */
            toBeArrayOfObjects<T>(): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayOfObjectsMatcher: (value: unknown) => jest.CustomMatcherResult;
