/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is an `Array` including only the values provided in the given `allowedValues` array and no others. The order and number of times each value appears in either array does not matter. Returns true unless `value` contains a value which does not feature in `allowedValues`.
             * @example
             * expect([5, 10, 1]).toBeArrayIncludingOnly([1, 5, 10]);
             */
            toBeArrayIncludingOnly(allowedValues: unknown[]): R;
        }
        interface Expect {
            /**
             * Asserts that a value is an `Array` including only the values provided in the given `allowedValues` array and no others. The order and number of times each value appears in either array does not matter. Returns true unless `value` contains a value which does not feature in `allowedValues`.
             * @example
             * expect([5, 10, 1]).toEqual(
             *   expect.toBeArrayIncludingOnly([1, 5, 10])
             * );
             */
            toBeArrayIncludingOnly<T>(allowedValues: unknown[]): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayIncludingOnlyMatcher: (value: unknown, allowedValues: unknown[]) => jest.CustomMatcherResult;
