/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that `value` is an `Array` including at least one of the members of `allowedValues`.
             * @example
             * expect([12, 0, 14, 'Ginola']).toBeArrayIncludingAnyOf(['Ginola', 3]);
             */
            toBeArrayIncludingAnyOf(allowedValues: unknown[]): R;
        }
        interface Expect {
            /**
             * Asserts that `value` is an `Array` including at least one of the members of `allowedValues`.
             * @example
             * expect([12, 0, 14, 'Ginola']).toEqual(
             *   expect.toBeArrayIncludingAnyOf(['Ginola', 3])
             * );
             */
            toBeArrayIncludingAnyOf<T>(allowedValues: unknown[]): JestMatchers<T>;
        }
    }
}
export declare const toBeArrayIncludingAnyOfMatcher: (value: unknown, allowedValues: unknown[]) => jest.CustomMatcherResult;
