"use strict";
/// <reference types="jest" />
exports.__esModule = true;
exports.toBeAfterMatcher = void 0;
var expect_more_1 = require("expect-more");
var jest_matcher_utils_1 = require("jest-matcher-utils");
var create_result_1 = require("./lib/create-result");
var toBeAfterMatcher = function (value, otherDate) {
    return (0, create_result_1.createResult)({
        message: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " to be an instance of Date, occurring after ").concat((0, jest_matcher_utils_1.printExpected)(otherDate));
        },
        notMessage: function () {
            return "expected ".concat((0, jest_matcher_utils_1.printReceived)(value), " not to be an instance of Date, occurring after ").concat((0, jest_matcher_utils_1.printExpected)(otherDate));
        },
        pass: (0, expect_more_1.isAfter)(otherDate, value)
    });
};
exports.toBeAfterMatcher = toBeAfterMatcher;
expect.extend({ toBeAfter: exports.toBeAfterMatcher });
