/// <reference types="jest" />
declare global {
    namespace jest {
        interface Matchers<R> {
            /**
             * Asserts that a value is a valid instance of `Date` whose value occurs after that of another.
             * @example
             * expect(new Date('2020-01-01')).toBeAfter(new Date('2019-12-31'));
             */
            toBeAfter(otherDate: Date): R;
        }
        interface Expect {
            /**
             * Asserts that a value is a valid instance of `Date` whose value occurs after that of another.
             * @example
             * expect(new Date('2020-01-01')).toEqual(
             *   expect.toBeAfter(new Date('2019-12-31'))
             * );
             */
            toBeAfter<T>(otherDate: Date): JestMatchers<T>;
        }
    }
}
export declare const toBeAfterMatcher: (value: unknown, otherDate: Date) => jest.CustomMatcherResult;
