"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatMessage = exports.escapeProperty = exports.escapeData = void 0;
const map = {
    '\r': '%0D',
    '\n': '%0A',
    '%': '%25',
    ',': '%2C',
    ':': '%3A',
};
const replacer = (match) => map[match];
const escapeData = (s) => String(s).replace(/[%\r\n]/gu, replacer);
exports.escapeData = escapeData;
const escapeProperty = (s) => String(s).replace(/[%\r\n:,]/gu, replacer);
exports.escapeProperty = escapeProperty;
const formatMessage = (message, ruleId) => ruleId ? `${message} (${ruleId})` : message;
exports.formatMessage = formatMessage;
//# sourceMappingURL=utils.js.map