import type { CompactEmoji, Emoji, ShortcodesDataset } from './types';
/**
 * By default, emoji skin modifications are nested under the base neutral skin tone emoji.
 * To flatten the data into a single dimension array, use the `flattenEmojiData` function.
 *
 * If `shortcodeDatasets` is defined, it will join the shortcodes to the emoji object using
 * `joinShortcodesToEmoji`.
 *
 * > Tags from the parent emoji will be passed down to the skin modifications.
 */
declare function flattenEmojiData(data: Emoji[], shortcodeDatasets?: ShortcodesDataset[]): Emoji[];
declare function flattenEmojiData(data: CompactEmoji[], shortcodeDatasets?: ShortcodesDataset[]): CompactEmoji[];
export { flattenEmojiData };
//# sourceMappingURL=flattenEmojiData.d.ts.map