function preventModifications(object) {
    return new Proxy(object, {
        get(target, prop) {
            const value = target[prop];
            // https://github.com/conventional-changelog/conventional-changelog/pull/1285
            if (value instanceof Date) {
                return value;
            }
            if (typeof value === 'object' && value !== null) {
                return preventModifications(value);
            }
            return value;
        },
        set() {
            throw new Error('Cannot modify immutable object.');
        },
        deleteProperty() {
            throw new Error('Cannot modify immutable object.');
        }
    });
}
/**
 * Apply transformation to commit.
 * @param commit
 * @param transform
 * @param args - Additional arguments for transformation function.
 * @returns Transformed commit.
 */
export async function transformCommit(commit, transform, ...args) {
    if (typeof transform === 'function') {
        const patch = await transform(preventModifications(commit), ...args);
        if (patch) {
            return {
                ...commit,
                ...patch,
                raw: commit
            };
        }
        return null;
    }
    return commit;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbWl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2NvbW1pdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFLQSxTQUFTLG9CQUFvQixDQUFzQixNQUFTO0lBQzFELE9BQU8sSUFBSSxLQUFLLENBQUMsTUFBTSxFQUFFO1FBQ3ZCLEdBQUcsQ0FBQyxNQUFNLEVBQUUsSUFBWTtZQUN0QixNQUFNLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFZLENBQUE7WUFFckMsNkVBQTZFO1lBQzdFLElBQUksS0FBSyxZQUFZLElBQUksRUFBRTtnQkFDekIsT0FBTyxLQUFLLENBQUE7YUFDYjtZQUVELElBQUksT0FBTyxLQUFLLEtBQUssUUFBUSxJQUFJLEtBQUssS0FBSyxJQUFJLEVBQUU7Z0JBQy9DLE9BQU8sb0JBQW9CLENBQUMsS0FBSyxDQUFDLENBQUE7YUFDbkM7WUFFRCxPQUFPLEtBQUssQ0FBQTtRQUNkLENBQUM7UUFDRCxHQUFHO1lBQ0QsTUFBTSxJQUFJLEtBQUssQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFBO1FBQ3BELENBQUM7UUFDRCxjQUFjO1lBQ1osTUFBTSxJQUFJLEtBQUssQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFBO1FBQ3BELENBQUM7S0FDRixDQUFDLENBQUE7QUFDSixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsTUFBTSxDQUFDLEtBQUssVUFBVSxlQUFlLENBQ25DLE1BQWMsRUFDZCxTQUEySCxFQUMzSCxHQUFHLElBQVU7SUFFYixJQUFJLE9BQU8sU0FBUyxLQUFLLFVBQVUsRUFBRTtRQUNuQyxNQUFNLEtBQUssR0FBRyxNQUFNLFNBQVMsQ0FBQyxvQkFBb0IsQ0FBQyxNQUFNLENBQUMsRUFBRSxHQUFHLElBQUksQ0FBQyxDQUFBO1FBRXBFLElBQUksS0FBSyxFQUFFO1lBQ1QsT0FBTztnQkFDTCxHQUFHLE1BQU07Z0JBQ1QsR0FBRyxLQUFLO2dCQUNSLEdBQUcsRUFBRSxNQUFNO2FBQ1osQ0FBQTtTQUNGO1FBRUQsT0FBTyxJQUFJLENBQUE7S0FDWjtJQUVELE9BQU8sTUFBTSxDQUFBO0FBQ2YsQ0FBQyJ9