"use strict";
/*
 * ---------------------------------------------------------
 * Copyright(C) Microsoft Corporation. All rights reserved.
 * ---------------------------------------------------------
 *
 * ---------------------------------------------------------
 * Generated file, DO NOT EDIT
 * ---------------------------------------------------------
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagementApi = void 0;
const basem = require("./ClientApiBases");
const ManagementInterfaces = require("./interfaces/ManagementInterfaces");
class ManagementApi extends basem.ClientApiBase {
    constructor(baseUrl, handlers, options, userAgent) {
        super(baseUrl, handlers, userAgent || 'node-Management-api', options);
    }
    /**
     * Determines if Code Security, Secret Protection, and their features are enabled for the repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     * @param {boolean} includeAllProperties - When true, will also determine if pushes are blocked when secrets are detected
     */
    getRepoEnablementStatus2(project, repository, includeAllProperties) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository
                };
                let queryValues = {
                    includeAllProperties: includeAllProperties,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "1fcb5ea0-1e19-4c71-ab26-0784bce2d551", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.RepoEnablementSettings, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Update the enablement status of Code Security and Secret Protection, along with their respective features, for a given repository.
     *
     * @param {ManagementInterfaces.RepoEnablementSettings} savedAdvSecEnablementStatus - new status
     * @param {string} project - Project ID or project name
     * @param {string} repository - Name or ID of the repository
     */
    updateRepoAdvSecEnablementStatus2(savedAdvSecEnablementStatus, project, repository) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "1fcb5ea0-1e19-4c71-ab26-0784bce2d551", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.update(url, savedAdvSecEnablementStatus, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * During multi-org billing computation in primary scale unit(EUS21), this API is used to create billing snapshot for a specific org. Primary scale unit will call this API for each org in different scsle units to create billing snapshot. Data will be stored in the org specific partition DB -> billing snapshot table. This is needed as customers will fetch billing data from their org specific partition DB.
     *
     * @param {ManagementInterfaces.MeterUsage} meterUsage
     */
    createBillingSnapshot(meterUsage) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "e58d8091-3d07-48b1-9527-7d6295fd4081", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.create(url, meterUsage, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get all billable committers details, including those not matched with a VSID.
     *
     * @param {Date} billingDate - The date to query, or if not provided, today
     */
    getBillableCommitterDetails(billingDate) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Details",
                };
                let queryValues = {
                    billingDate: billingDate,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "e58d8091-3d07-48b1-9527-7d6295fd4081", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.BillableCommitterDetails, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     */
    getLastMeterUsage() {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Last",
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "e58d8091-3d07-48b1-9527-7d6295fd4081", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.MeterUsage, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get commiters used when calculating billing information.
     *
     * @param {Date} billingDate - The date to query, or if not provided, today
     */
    getMeterUsage(billingDate) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                };
                let queryValues = {
                    billingDate: billingDate,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "e58d8091-3d07-48b1-9527-7d6295fd4081", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.MeterUsage, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * During multi-org billing computation in primary scale unit(EUS21), this API is used to create billing snapshot for a specific org. Primary scale unit will call this API for each org in different scsle units to create billing snapshot. Data will be stored in the org specific partition DB -> billing snapshot table. This is needed as customers will fetch billing data from their org specific partition DB.
     *
     * @param {ManagementInterfaces.MeterUsageForPlan} meterUsage
     * @param {ManagementInterfaces.Plan} plan
     */
    createBillingSnapshot2(meterUsage, plan) {
        return __awaiter(this, void 0, void 0, function* () {
            if (plan == null) {
                throw new TypeError('plan can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                };
                let queryValues = {
                    plan: plan,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "9615bfcf-d592-4664-9059-4be0150ff16d", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.create(url, meterUsage, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get all billable committers details, including those not matched with a VSID.
     *
     * @param {ManagementInterfaces.Plan} plan - The plan to query. Plans supported: CodeSecurity and SecretProtection. This is a mandatory parameter.
     * @param {Date} billingDate - The date to query, or if not provided, today
     */
    getBillableCommitterDetails2(plan, billingDate) {
        return __awaiter(this, void 0, void 0, function* () {
            if (plan == null) {
                throw new TypeError('plan can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Details",
                };
                let queryValues = {
                    plan: plan,
                    billingDate: billingDate,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "9615bfcf-d592-4664-9059-4be0150ff16d", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.BillableCommitterDetails, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * @param {ManagementInterfaces.Plan} plan
     */
    getLastMeterUsage2(plan) {
        return __awaiter(this, void 0, void 0, function* () {
            if (plan == null) {
                throw new TypeError('plan can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Last",
                };
                let queryValues = {
                    plan: plan,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "9615bfcf-d592-4664-9059-4be0150ff16d", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.MeterUsageForPlan, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get commiters used when calculating billing information.
     *
     * @param {ManagementInterfaces.Plan} plan - The plan to query. Plans supported: CodeSecurity and SecretProtection. This is a mandatory parameter.
     * @param {Date} billingDate - The date to query, or if not provided, today
     */
    getMeterUsage2(plan, billingDate) {
        return __awaiter(this, void 0, void 0, function* () {
            if (plan == null) {
                throw new TypeError('plan can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                };
                let queryValues = {
                    plan: plan,
                    billingDate: billingDate,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "9615bfcf-d592-4664-9059-4be0150ff16d", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.MeterUsageForPlan, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get the current status of Advanced Security for the organization
     *
     * @param {boolean} includeAllProperties - When true, also determine if pushes are blocked if they contain secrets
     */
    getOrgEnablementStatus(includeAllProperties) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {};
                let queryValues = {
                    includeAllProperties: includeAllProperties,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "d0c0450f-8882-46f4-a5a8-e48fea3095b0", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.AdvSecEnablementSettings, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Update the status of Advanced Security for the organization
     *
     * @param {ManagementInterfaces.AdvSecEnablementSettingsUpdate} savedAdvSecEnablementStatus - The new status
     */
    updateOrgEnablementStatus(savedAdvSecEnablementStatus) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {};
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "d0c0450f-8882-46f4-a5a8-e48fea3095b0", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.update(url, savedAdvSecEnablementStatus, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get the current status of Advanced Security for the organization
     *
     * @param {boolean} includeAllProperties - When true, also determine if pushes are blocked if they contain secrets
     */
    getOrgEnablementStatus2(includeAllProperties) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {};
                let queryValues = {
                    includeAllProperties: includeAllProperties,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "41d7fd8d-71f1-485f-b48d-f68eb7f04a6b", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.OrgEnablementSettings, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Update the status of Advanced Security for the organization
     *
     * @param {ManagementInterfaces.OrgEnablementSettings} orgEnablementSettings - The new status
     */
    updateOrgEnablementStatus2(orgEnablementSettings) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {};
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "41d7fd8d-71f1-485f-b48d-f68eb7f04a6b", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.update(url, orgEnablementSettings, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this organization.
     *
     */
    getEstimatedBillablePushersDetailsForOrg() {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Details",
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "10a9e9c3-89bf-4312-92ed-139ddbcd2e28", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the committers that would be added to the customer's usage if Advanced Security was enabled for this organization.
     *
     */
    getEstimatedOrgBillablePushers() {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "10a9e9c3-89bf-4312-92ed-139ddbcd2e28", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this organization.
     *
     * @param {ManagementInterfaces.Plan} plan - The plan to query.
     */
    getEstimatedBillablePushersDetailsForOrg2(plan) {
        return __awaiter(this, void 0, void 0, function* () {
            if (plan == null) {
                throw new TypeError('plan can not be null or undefined');
            }
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                };
                let queryValues = {
                    plan: plan,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "3fae4c8a-0597-45be-bf45-2925fe8036b3", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get the current status of Advanced Security for a project
     *
     * @param {string} project - Project ID or project name
     * @param {boolean} includeAllProperties - When true, also determine if pushes are blocked if they contain secrets
     */
    getProjectEnablementStatus(project, includeAllProperties) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project
                };
                let queryValues = {
                    includeAllProperties: includeAllProperties,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "6b9a4b47-5f2d-40f3-8286-b0152079074d", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.AdvSecEnablementSettings, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Update the status of Advanced Security for the project
     *
     * @param {ManagementInterfaces.AdvSecEnablementSettingsUpdate} savedAdvSecEnablementStatus - The new status
     * @param {string} project - Project ID or project name
     */
    updateProjectEnablementStatus(savedAdvSecEnablementStatus, project) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "6b9a4b47-5f2d-40f3-8286-b0152079074d", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.update(url, savedAdvSecEnablementStatus, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Get the current status of Advanced Security for a project
     *
     * @param {string} project - Project ID or project name
     * @param {boolean} includeAllProperties - When true, also determine if pushes are blocked if they contain secrets
     */
    getProjectEnablementStatus2(project, includeAllProperties) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project
                };
                let queryValues = {
                    includeAllProperties: includeAllProperties,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "534d98d2-d5a0-4bf4-94b3-1328019302f8", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.ProjectEnablementSettings, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Update the status of Advanced Security for the project
     *
     * @param {ManagementInterfaces.ProjectEnablementSettings} projectEnablementSettings - The new status
     * @param {string} project - Project ID or project name
     */
    updateProjectEnablementStatus2(projectEnablementSettings, project) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "534d98d2-d5a0-4bf4-94b3-1328019302f8", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.update(url, projectEnablementSettings, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this project.
     *
     * @param {string} project - Project ID or project name
     */
    getEstimatedBillablePushersDetailsForProject(project) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Details",
                    project: project
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "bf09cb40-ecf4-4496-8cf7-9ec60c64fd3e", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the number of committers that would be added to the customer's usage if Advanced Security was enabled for this project.
     *
     * @param {string} project - Project ID or project name
     */
    getEstimatedBillablePushersForProject(project) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                    project: project
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "bf09cb40-ecf4-4496-8cf7-9ec60c64fd3e", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this project.
     *
     * @param {string} project - Project ID or project name
     * @param {ManagementInterfaces.Plan} plan
     */
    getEstimatedBillablePushersDetailsForProject2(project, plan) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                    project: project
                };
                let queryValues = {
                    plan: plan,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "ffd0d73d-54b4-4f56-9d83-e8b08db8bfcf", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Determine if Advanced Security is enabled for a repository
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     * @param {boolean} includeAllProperties - When true, will also determine if pushes are blocked when secrets are detected
     */
    getRepoEnablementStatus(project, repository, includeAllProperties) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository
                };
                let queryValues = {
                    includeAllProperties: includeAllProperties,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "d11a1c2b-b904-43dc-b970-bf42486262db", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, ManagementInterfaces.TypeInfo.AdvSecEnablementStatus, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Update the enablement of Advanced Security for a repository
     *
     * @param {ManagementInterfaces.AdvSecEnablementStatusUpdate} savedAdvSecEnablementStatus - new status
     * @param {string} project - Project ID or project name
     * @param {string} repository - Name or ID of the repository
     */
    updateRepoAdvSecEnablementStatus(savedAdvSecEnablementStatus, project, repository) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    project: project,
                    repository: repository
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "d11a1c2b-b904-43dc-b970-bf42486262db", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.update(url, savedAdvSecEnablementStatus, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the committers that would be added to the customer's usage if Advanced Security was enabled for this repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository
     */
    getEstimatedBillableCommitersDetailsForRepo(project, repository) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Details",
                    project: project,
                    repository: repository
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "b60f1ebf-ae77-4557-bd7f-ae3d5598dd1f", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the committers that would be added to the customer's usage if Advanced Security was enabled for this repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     */
    getEstimatedBillableCommittersForRepo(project, repository) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                    project: project,
                    repository: repository
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "b60f1ebf-ae77-4557-bd7f-ae3d5598dd1f", routeValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, true);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     * @param {ManagementInterfaces.Plan} plan - The plan to query.
     */
    getEstimatedRepoBillableCommittersDetails2(project, repository, plan) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
                let routeValues = {
                    action: "Default",
                    project: project,
                    repository: repository
                };
                let queryValues = {
                    plan: plan,
                };
                try {
                    let verData = yield this.vsoClient.getVersioningData("7.2-preview.1", "Management", "1a7b7e0d-e0b6-48b4-b0b6-9b6c2a1984e3", routeValues, queryValues);
                    let url = verData.requestUrl;
                    let options = this.createRequestOptions('application/json', verData.apiVersion);
                    let res;
                    res = yield this.rest.get(url, options);
                    let ret = this.formatResponse(res.result, null, false);
                    resolve(ret);
                }
                catch (err) {
                    reject(err);
                }
            }));
        });
    }
}
exports.ManagementApi = ManagementApi;
