import basem = require('./ClientApiBases');
import VsoBaseInterfaces = require('./interfaces/common/VsoBaseInterfaces');
import ManagementInterfaces = require("./interfaces/ManagementInterfaces");
export interface IManagementApi extends basem.ClientApiBase {
    getRepoEnablementStatus2(project: string, repository: string, includeAllProperties?: boolean): Promise<ManagementInterfaces.RepoEnablementSettings>;
    updateRepoAdvSecEnablementStatus2(savedAdvSecEnablementStatus: ManagementInterfaces.RepoEnablementSettings, project: string, repository: string): Promise<void>;
    createBillingSnapshot(meterUsage: ManagementInterfaces.MeterUsage): Promise<void>;
    getBillableCommitterDetails(billingDate?: Date): Promise<ManagementInterfaces.BillableCommitterDetails[]>;
    getLastMeterUsage(): Promise<ManagementInterfaces.MeterUsage>;
    getMeterUsage(billingDate?: Date): Promise<ManagementInterfaces.MeterUsage>;
    createBillingSnapshot2(meterUsage: ManagementInterfaces.MeterUsageForPlan, plan: ManagementInterfaces.Plan): Promise<void>;
    getBillableCommitterDetails2(plan: ManagementInterfaces.Plan, billingDate?: Date): Promise<ManagementInterfaces.BillableCommitterDetails[]>;
    getLastMeterUsage2(plan: ManagementInterfaces.Plan): Promise<ManagementInterfaces.MeterUsageForPlan>;
    getMeterUsage2(plan: ManagementInterfaces.Plan, billingDate?: Date): Promise<ManagementInterfaces.MeterUsageForPlan>;
    getOrgEnablementStatus(includeAllProperties?: boolean): Promise<ManagementInterfaces.AdvSecEnablementSettings>;
    updateOrgEnablementStatus(savedAdvSecEnablementStatus: ManagementInterfaces.AdvSecEnablementSettingsUpdate): Promise<void>;
    getOrgEnablementStatus2(includeAllProperties?: boolean): Promise<ManagementInterfaces.OrgEnablementSettings>;
    updateOrgEnablementStatus2(orgEnablementSettings: ManagementInterfaces.OrgEnablementSettings): Promise<void>;
    getEstimatedBillablePushersDetailsForOrg(): Promise<ManagementInterfaces.BilledCommitter[]>;
    getEstimatedOrgBillablePushers(): Promise<string[]>;
    getEstimatedBillablePushersDetailsForOrg2(plan: ManagementInterfaces.Plan): Promise<ManagementInterfaces.MeterUsageEstimate>;
    getProjectEnablementStatus(project: string, includeAllProperties?: boolean): Promise<ManagementInterfaces.AdvSecEnablementSettings>;
    updateProjectEnablementStatus(savedAdvSecEnablementStatus: ManagementInterfaces.AdvSecEnablementSettingsUpdate, project: string): Promise<void>;
    getProjectEnablementStatus2(project: string, includeAllProperties?: boolean): Promise<ManagementInterfaces.ProjectEnablementSettings>;
    updateProjectEnablementStatus2(projectEnablementSettings: ManagementInterfaces.ProjectEnablementSettings, project: string): Promise<void>;
    getEstimatedBillablePushersDetailsForProject(project: string): Promise<ManagementInterfaces.BilledCommitter[]>;
    getEstimatedBillablePushersForProject(project: string): Promise<string[]>;
    getEstimatedBillablePushersDetailsForProject2(project: string, plan?: ManagementInterfaces.Plan): Promise<ManagementInterfaces.MeterUsageEstimate>;
    getRepoEnablementStatus(project: string, repository: string, includeAllProperties?: boolean): Promise<ManagementInterfaces.AdvSecEnablementStatus>;
    updateRepoAdvSecEnablementStatus(savedAdvSecEnablementStatus: ManagementInterfaces.AdvSecEnablementStatusUpdate, project: string, repository: string): Promise<void>;
    getEstimatedBillableCommitersDetailsForRepo(project: string, repository: string): Promise<ManagementInterfaces.BilledCommitter[]>;
    getEstimatedBillableCommittersForRepo(project: string, repository: string): Promise<string[]>;
    getEstimatedRepoBillableCommittersDetails2(project: string, repository: string, plan?: ManagementInterfaces.Plan): Promise<ManagementInterfaces.MeterUsageEstimate>;
}
export declare class ManagementApi extends basem.ClientApiBase implements IManagementApi {
    constructor(baseUrl: string, handlers: VsoBaseInterfaces.IRequestHandler[], options?: VsoBaseInterfaces.IRequestOptions, userAgent?: string);
    /**
     * Determines if Code Security, Secret Protection, and their features are enabled for the repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     * @param {boolean} includeAllProperties - When true, will also determine if pushes are blocked when secrets are detected
     */
    getRepoEnablementStatus2(project: string, repository: string, includeAllProperties?: boolean): Promise<ManagementInterfaces.RepoEnablementSettings>;
    /**
     * Update the enablement status of Code Security and Secret Protection, along with their respective features, for a given repository.
     *
     * @param {ManagementInterfaces.RepoEnablementSettings} savedAdvSecEnablementStatus - new status
     * @param {string} project - Project ID or project name
     * @param {string} repository - Name or ID of the repository
     */
    updateRepoAdvSecEnablementStatus2(savedAdvSecEnablementStatus: ManagementInterfaces.RepoEnablementSettings, project: string, repository: string): Promise<void>;
    /**
     * During multi-org billing computation in primary scale unit(EUS21), this API is used to create billing snapshot for a specific org. Primary scale unit will call this API for each org in different scsle units to create billing snapshot. Data will be stored in the org specific partition DB -> billing snapshot table. This is needed as customers will fetch billing data from their org specific partition DB.
     *
     * @param {ManagementInterfaces.MeterUsage} meterUsage
     */
    createBillingSnapshot(meterUsage: ManagementInterfaces.MeterUsage): Promise<void>;
    /**
     * Get all billable committers details, including those not matched with a VSID.
     *
     * @param {Date} billingDate - The date to query, or if not provided, today
     */
    getBillableCommitterDetails(billingDate?: Date): Promise<ManagementInterfaces.BillableCommitterDetails[]>;
    /**
     */
    getLastMeterUsage(): Promise<ManagementInterfaces.MeterUsage>;
    /**
     * Get commiters used when calculating billing information.
     *
     * @param {Date} billingDate - The date to query, or if not provided, today
     */
    getMeterUsage(billingDate?: Date): Promise<ManagementInterfaces.MeterUsage>;
    /**
     * During multi-org billing computation in primary scale unit(EUS21), this API is used to create billing snapshot for a specific org. Primary scale unit will call this API for each org in different scsle units to create billing snapshot. Data will be stored in the org specific partition DB -> billing snapshot table. This is needed as customers will fetch billing data from their org specific partition DB.
     *
     * @param {ManagementInterfaces.MeterUsageForPlan} meterUsage
     * @param {ManagementInterfaces.Plan} plan
     */
    createBillingSnapshot2(meterUsage: ManagementInterfaces.MeterUsageForPlan, plan: ManagementInterfaces.Plan): Promise<void>;
    /**
     * Get all billable committers details, including those not matched with a VSID.
     *
     * @param {ManagementInterfaces.Plan} plan - The plan to query. Plans supported: CodeSecurity and SecretProtection. This is a mandatory parameter.
     * @param {Date} billingDate - The date to query, or if not provided, today
     */
    getBillableCommitterDetails2(plan: ManagementInterfaces.Plan, billingDate?: Date): Promise<ManagementInterfaces.BillableCommitterDetails[]>;
    /**
     * @param {ManagementInterfaces.Plan} plan
     */
    getLastMeterUsage2(plan: ManagementInterfaces.Plan): Promise<ManagementInterfaces.MeterUsageForPlan>;
    /**
     * Get commiters used when calculating billing information.
     *
     * @param {ManagementInterfaces.Plan} plan - The plan to query. Plans supported: CodeSecurity and SecretProtection. This is a mandatory parameter.
     * @param {Date} billingDate - The date to query, or if not provided, today
     */
    getMeterUsage2(plan: ManagementInterfaces.Plan, billingDate?: Date): Promise<ManagementInterfaces.MeterUsageForPlan>;
    /**
     * Get the current status of Advanced Security for the organization
     *
     * @param {boolean} includeAllProperties - When true, also determine if pushes are blocked if they contain secrets
     */
    getOrgEnablementStatus(includeAllProperties?: boolean): Promise<ManagementInterfaces.AdvSecEnablementSettings>;
    /**
     * Update the status of Advanced Security for the organization
     *
     * @param {ManagementInterfaces.AdvSecEnablementSettingsUpdate} savedAdvSecEnablementStatus - The new status
     */
    updateOrgEnablementStatus(savedAdvSecEnablementStatus: ManagementInterfaces.AdvSecEnablementSettingsUpdate): Promise<void>;
    /**
     * Get the current status of Advanced Security for the organization
     *
     * @param {boolean} includeAllProperties - When true, also determine if pushes are blocked if they contain secrets
     */
    getOrgEnablementStatus2(includeAllProperties?: boolean): Promise<ManagementInterfaces.OrgEnablementSettings>;
    /**
     * Update the status of Advanced Security for the organization
     *
     * @param {ManagementInterfaces.OrgEnablementSettings} orgEnablementSettings - The new status
     */
    updateOrgEnablementStatus2(orgEnablementSettings: ManagementInterfaces.OrgEnablementSettings): Promise<void>;
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this organization.
     *
     */
    getEstimatedBillablePushersDetailsForOrg(): Promise<ManagementInterfaces.BilledCommitter[]>;
    /**
     * Estimate the committers that would be added to the customer's usage if Advanced Security was enabled for this organization.
     *
     */
    getEstimatedOrgBillablePushers(): Promise<string[]>;
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this organization.
     *
     * @param {ManagementInterfaces.Plan} plan - The plan to query.
     */
    getEstimatedBillablePushersDetailsForOrg2(plan: ManagementInterfaces.Plan): Promise<ManagementInterfaces.MeterUsageEstimate>;
    /**
     * Get the current status of Advanced Security for a project
     *
     * @param {string} project - Project ID or project name
     * @param {boolean} includeAllProperties - When true, also determine if pushes are blocked if they contain secrets
     */
    getProjectEnablementStatus(project: string, includeAllProperties?: boolean): Promise<ManagementInterfaces.AdvSecEnablementSettings>;
    /**
     * Update the status of Advanced Security for the project
     *
     * @param {ManagementInterfaces.AdvSecEnablementSettingsUpdate} savedAdvSecEnablementStatus - The new status
     * @param {string} project - Project ID or project name
     */
    updateProjectEnablementStatus(savedAdvSecEnablementStatus: ManagementInterfaces.AdvSecEnablementSettingsUpdate, project: string): Promise<void>;
    /**
     * Get the current status of Advanced Security for a project
     *
     * @param {string} project - Project ID or project name
     * @param {boolean} includeAllProperties - When true, also determine if pushes are blocked if they contain secrets
     */
    getProjectEnablementStatus2(project: string, includeAllProperties?: boolean): Promise<ManagementInterfaces.ProjectEnablementSettings>;
    /**
     * Update the status of Advanced Security for the project
     *
     * @param {ManagementInterfaces.ProjectEnablementSettings} projectEnablementSettings - The new status
     * @param {string} project - Project ID or project name
     */
    updateProjectEnablementStatus2(projectEnablementSettings: ManagementInterfaces.ProjectEnablementSettings, project: string): Promise<void>;
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this project.
     *
     * @param {string} project - Project ID or project name
     */
    getEstimatedBillablePushersDetailsForProject(project: string): Promise<ManagementInterfaces.BilledCommitter[]>;
    /**
     * Estimate the number of committers that would be added to the customer's usage if Advanced Security was enabled for this project.
     *
     * @param {string} project - Project ID or project name
     */
    getEstimatedBillablePushersForProject(project: string): Promise<string[]>;
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this project.
     *
     * @param {string} project - Project ID or project name
     * @param {ManagementInterfaces.Plan} plan
     */
    getEstimatedBillablePushersDetailsForProject2(project: string, plan?: ManagementInterfaces.Plan): Promise<ManagementInterfaces.MeterUsageEstimate>;
    /**
     * Determine if Advanced Security is enabled for a repository
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     * @param {boolean} includeAllProperties - When true, will also determine if pushes are blocked when secrets are detected
     */
    getRepoEnablementStatus(project: string, repository: string, includeAllProperties?: boolean): Promise<ManagementInterfaces.AdvSecEnablementStatus>;
    /**
     * Update the enablement of Advanced Security for a repository
     *
     * @param {ManagementInterfaces.AdvSecEnablementStatusUpdate} savedAdvSecEnablementStatus - new status
     * @param {string} project - Project ID or project name
     * @param {string} repository - Name or ID of the repository
     */
    updateRepoAdvSecEnablementStatus(savedAdvSecEnablementStatus: ManagementInterfaces.AdvSecEnablementStatusUpdate, project: string, repository: string): Promise<void>;
    /**
     * Estimate the committers that would be added to the customer's usage if Advanced Security was enabled for this repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository
     */
    getEstimatedBillableCommitersDetailsForRepo(project: string, repository: string): Promise<ManagementInterfaces.BilledCommitter[]>;
    /**
     * Estimate the committers that would be added to the customer's usage if Advanced Security was enabled for this repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     */
    getEstimatedBillableCommittersForRepo(project: string, repository: string): Promise<string[]>;
    /**
     * Estimate the pushers that would be added to the customer's usage if Advanced Security was enabled for this repository.
     *
     * @param {string} project - Project ID or project name
     * @param {string} repository - The name or ID of the repository
     * @param {ManagementInterfaces.Plan} plan - The plan to query.
     */
    getEstimatedRepoBillableCommittersDetails2(project: string, repository: string, plan?: ManagementInterfaces.Plan): Promise<ManagementInterfaces.MeterUsageEstimate>;
}
