import { Client, MetadataBearer } from '@smithy/types';
import sinon, { SinonSandbox } from 'sinon';
import { AwsStub } from './awsClientStub';
/**
 * Creates and attaches a stub of the `Client#send()` method. Only this single method is mocked.
 * If method is already a stub, it's replaced.
 * @param client `Client` type or instance to replace the method
 * @param sandbox Optional sinon sandbox to use
 * @return Stub allowing to configure Client's behavior
 */
export declare const mockClient: <TInput extends object, TOutput extends MetadataBearer, TConfiguration>(client: InstanceOrClassType<Client<TInput, TOutput, TConfiguration>>, { sandbox }?: {
    sandbox?: sinon.SinonSandbox | undefined;
}) => AwsStub<TInput, TOutput, TConfiguration>;
type ClassType<T> = {
    prototype: T;
};
type InstanceOrClassType<T> = T | ClassType<T>;
export {};
