"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mockClient = void 0;
const tslib_1 = require("tslib");
const sinon_1 = tslib_1.__importDefault(require("sinon"));
const sinon_2 = require("./sinon");
const awsClientStub_1 = require("./awsClientStub");
/**
 * Creates and attaches a stub of the `Client#send()` method. Only this single method is mocked.
 * If method is already a stub, it's replaced.
 * @param client `Client` type or instance to replace the method
 * @param sandbox Optional sinon sandbox to use
 * @return Stub allowing to configure Client's behavior
 */
const mockClient = (client, { sandbox } = {}) => {
    const instance = isClientInstance(client) ? client : client.prototype;
    const send = instance.send;
    if ((0, sinon_2.isSinonStub)(send)) {
        send.restore();
    }
    const sinonSandbox = sandbox || sinon_1.default;
    const sendStub = sinonSandbox.stub(instance, 'send');
    // eslint-disable-next-line @typescript-eslint/no-unsafe-argument
    return new awsClientStub_1.AwsStub(instance, sendStub);
};
exports.mockClient = mockClient;
/**
 * Type guard to differentiate `Client` instance from a type.
 */
const isClientInstance = (obj) => obj.send !== undefined;
//# sourceMappingURL=mockClient.js.map