"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _util = require("./util");

// lol dis
var body = /((?:[a-zA-Z0-9._~+\/-]+=*(?:\s+|$))|[^\u0000-\u001F\u007F()<>@,;:\\"/?={}\[\]\u0020\u0009]+)(?:=([^\\"=\s,]+|"(?:[^"\\]|\\.)*"))?/g; // eslint-disable-line

var normalize = function normalize(prev, _cur) {
  // Fixup quoted strings and tokens with spaces around them
  var cur = _cur.charAt(0) === '"' ? (0, _util.unquote)(_cur) : _cur.trim(); // Marshal

  if (Array.isArray(prev)) {
    return prev.concat(cur);
  } else if (typeof prev === 'string') {
    return [prev, cur];
  }

  return cur;
};

var parseProperties = function parseProperties(scheme, string) {
  var token = null;
  var params = {}; // eslint-disable-next-line no-constant-condition

  while (true) {
    var res = body.exec(string);

    if (res === null) {
      break;
    }

    if (res[2]) {
      params[res[1]] = normalize(params[res[1]], res[2]);
    } else {
      token = normalize(token, res[1]);
    }
  }

  return {
    scheme,
    params,
    token
  };
};

var _default = function _default(str) {
  if (typeof str !== 'string') {
    throw new TypeError('Header value must be a string.');
  }

  var start = str.indexOf(' ');
  var scheme = str.substr(0, start);

  if (!(0, _util.isScheme)(scheme)) {
    throw new TypeError(`Invalid scheme ${scheme}`);
  }

  return parseProperties(scheme, str.substr(start));
};

exports.default = _default;
//# sourceMappingURL=parse.js.map