import { FakeFS, PortablePath } from '@yarnpkg/fslib';
import { Stat, type CompressionData, type ZipImpl, type ZipImplInput } from './ZipFS';
export interface Entry {
    name: string;
    compressionMethod: number;
    size: number;
    os: number;
    isSymbolicLink: boolean;
    crc: number;
    compressedSize: number;
    externalAttributes: number;
    mtime: number;
    localHeaderOffset: number;
}
export declare class JsZipImpl implements ZipImpl {
    private fd;
    private baseFs;
    private entries;
    filesShouldBeCached: boolean;
    constructor(opts: ZipImplInput);
    static readZipSync(fd: number, baseFs: FakeFS<PortablePath>, fileSize: number): Array<Entry>;
    getExternalAttributes(index: number): [opsys: number, attributes: number];
    getListings(): Array<string>;
    getSymlinkCount(): number;
    stat(index: number): Stat;
    locate(name: string): number;
    getFileSource(index: number): {
        data: Buffer;
        compressionMethod: number;
    };
    discard(): void;
    addDirectory(path: string): number;
    deleteEntry(index: number): void;
    setMtime(index: number, mtime: number): void;
    getBufferAndClose(): Buffer;
    setFileSource(target: PortablePath, compression: CompressionData, buffer: Buffer): number;
    setExternalAttributes(index: number, opsys: number, attributes: number): void;
}
