declare enum PathType {
    File = 0,
    Portable = 1,
    Native = 2
}
export type PortablePath = string & {
    __pathType: PathType.File | PathType.Portable;
};
export type NativePath = string & {
    __pathType?: PathType.File | PathType.Native;
};
export declare const PortablePath: {
    root: PortablePath;
    dot: PortablePath;
    parent: PortablePath;
};
export type Filename = string & {
    __pathType: PathType.File;
};
export type Path = PortablePath | NativePath;
export declare const Filename: {
    home: Filename;
    nodeModules: Filename;
    manifest: Filename;
    lockfile: Filename;
    virtual: Filename;
    /**
     * @deprecated
     */
    pnpJs: Filename;
    pnpCjs: Filename;
    pnpData: Filename;
    pnpEsmLoader: Filename;
    rc: Filename;
    env: Filename;
};
export type TolerateLiterals<T> = {
    [K in keyof T]: ValidateLiteral<T[K]> | PortablePath | Filename;
};
export type ValidateLiteral<T> = T extends `${infer X}` ? T : never;
export interface PortablePathGenerics {
    join<T extends Array<string>>(...segments: TolerateLiterals<T>): PortablePath;
    resolve<T extends string>(...pathSegments: Array<PortablePath | Filename | TolerateLiterals<T>>): PortablePath;
}
export type FSPath<T extends Path> = T | number;
export declare const npath: PathUtils<NativePath> & ConvertUtils;
export declare const ppath: PathUtils<PortablePath> & PortablePathGenerics;
export interface ParsedPath<P extends Path> {
    root: P;
    dir: P;
    base: Filename;
    ext: string;
    name: Filename;
}
export interface FormatInputPathObject<P extends Path> {
    root?: P;
    dir?: P;
    base?: Filename;
    ext?: string;
    name?: Filename;
}
type NoInfer<T> = [T][T extends any ? 0 : never];
export interface PathUtils<P extends Path> {
    cwd(): P;
    join(...paths: Array<NoInfer<P> | Filename>): P;
    resolve(...pathSegments: Array<NoInfer<P> | Filename>): P;
    normalize(p: P): P;
    isAbsolute(path: P): boolean;
    relative(from: P, to: P): P;
    dirname(p: P): P;
    basename(p: P, ext?: string): Filename;
    extname(p: P): string;
    readonly sep: P;
    readonly delimiter: string;
    parse(pathString: P): ParsedPath<P>;
    format(pathObject: FormatInputPathObject<P>): P;
    contains(from: P, to: P): P | null;
}
export interface ConvertUtils {
    fromPortablePath: (p: Path) => NativePath;
    toPortablePath: (p: Path) => PortablePath;
}
export declare function convertPath<P extends Path>(targetPathUtils: PathUtils<P>, sourcePath: Path): P;
export {};
