import { NoParamCallback } from 'fs';
import { Dir, DirentNoPath, FakeFS } from '../FakeFS';
import { Filename, Path } from '../path';
export type CustomDirOptions = {
    onClose?: () => void;
};
export declare class CustomDir<P extends Path> implements Dir<P> {
    readonly path: P;
    private readonly nextDirent;
    private readonly opts;
    constructor(path: P, nextDirent: () => DirentNoPath | null, opts?: CustomDirOptions);
    closed: boolean;
    throwIfClosed(): void;
    [Symbol.asyncIterator](): AsyncGenerator<DirentNoPath, void, unknown>;
    read(): Promise<DirentNoPath>;
    read(cb: (err: NodeJS.ErrnoException | null, dirent: DirentNoPath | null) => void): void;
    readSync(): DirentNoPath | null;
    close(): Promise<void>;
    close(cb: NoParamCallback): void;
    closeSync(): void;
}
export declare function opendir<P extends Path>(fakeFs: FakeFS<P>, path: P, entries: Array<Filename>, opts?: CustomDirOptions): CustomDir<P>;
