export interface TaskPool<TIn, TOut> {
    run(data: TIn): Promise<TOut>;
}
export declare class AsyncPool<TIn, TOut> implements TaskPool<TIn, TOut> {
    private fn;
    private limit;
    constructor(fn: (data: TIn) => Promise<TOut>, opts: {
        poolSize: number;
    });
    run(data: TIn): Promise<TOut>;
}
export declare class WorkerPool<TIn, TOut> implements TaskPool<TIn, TOut> {
    private source;
    private workers;
    private cleanupInterval;
    private limit;
    constructor(source: string, opts: {
        poolSize: number;
    });
    private createWorker;
    run(data: TIn): Promise<TOut>;
}
