# Installation
> `npm install --save @types/treeify`

# Summary
This package contains type definitions for treeify (https://github.com/notatestuser/treeify).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/treeify.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/treeify/index.d.ts)
````ts
export interface TreeObject {
    [k: string]: TreeValue;
}
export type TreeValue = string | TreeObject;

export function asTree(
    treeObj: TreeObject,
    showValues: boolean,
    hideFunctions: boolean,
): string;

export function asLines(
    treeObj: TreeObject,
    showValues: boolean,
    lineCallback: (line: string) => void,
): string;
export function asLines(
    treeObj: TreeObject,
    showValues: boolean,
    hideFunctions: boolean,
    lineCallback: (line: string) => void,
): string;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 15:11:36 GMT
 * Dependencies: none

# Credits
These definitions were written by [Mike North](https://github.com/mike-north).
